(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8619,        217]*)
(*NotebookOutlinePosition[      9463,        244]*)
(*  CellTagsIndexPosition[      9419,        240]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\ This\ file\ is\ called\ galerkin1 . nb\ in\ Example\ 6.2  .1 . \ 
          It\ should\ be\ corrected\ as\ galerkin6 . 
          nb\ there\ instead\ of\ galerkin1 . nb, \ 
      since\ galerkin1 . 
          nb\ is\ the\ file\ used\ in\ Example\ 2.2 \( \(.3\)\(.\)\)\ *) \
\[IndentingNewLine] (*\ 
      Gauss\ quadrature\ with\ m = 
        12\ from\  - \[Pi]\ to\ \(\(\[Pi]\)\(.\)\)\ \ *) \n (*\ \[Tau]_i = \(\
\[Pi]\[Xi]_i\ \n
        Note\ that\ integral = 
          sum\ w_i\ f \((\[Xi]_i)\)\)\ \ *) \n\(\[Xi]1 = \(-0.9815606342\);\)\
\), "\n", 
    \(\(\[Xi]2 = \(-0.9041172564\);\)\), "\n", 
    \(\(\[Xi]3 = \(-0.7699026742\);\)\), "\n", 
    \(\(\[Xi]4 = \(-0.5873179543\);\)\), "\n", 
    \(\(\[Xi]5 = \(-0.3678314990\);\)\), "\n", 
    \(\(\[Xi]6 = \(-0.1252334085\);\)\), "\n", 
    \(\(\[Xi]7 = 0.1252334085;\)\), "\n", 
    \(\(\[Xi]8 = 0.3678314990;\)\), "\n", 
    \(\(\[Xi]9 = 0.5873179543;\)\), "\n", 
    \(\(\[Xi]10 = 0.7699026742;\)\), "\n", 
    \(\(\[Xi]11 = 0.9041172564;\)\), "\n", 
    \(\(\[Xi]12 = 0.9815606342;\)\), "\n", 
    \(\(w1 = 0.0471753364;\)\), "\n", 
    \(\(w2 = 0.1069393260;\)\), "\n", 
    \(\(w3 = 0.1600783285;\)\), "\n", 
    \(\(w4 = 0.2031674267;\)\), "\n", 
    \(\(w5 = 0.2334925365;\)\), "\n", 
    \(\(w6 = 0.2491470458;\)\), "\n", 
    \(\(w7 = 0.2491470458;\)\), "\n", 
    \(\(w8 = 0.2334925365;\)\), "\n", 
    \(\(w9 = 0.2031674267;\)\), "\n", 
    \(\(w10 = 0.1600783285;\)\), "\n", 
    \(\(w11 = 0.1069393260;\)\), "\n", 
    \(\(w12 = 0.0471753364;\)\), "\n", 
    \(\(f[t_, \[Tau]_]\  := \ 
        1/\((0.68\  - \ 
              0.32*Cos[
                  t + \[Tau]])\);\)\n (*\ \ The\ lhs\ of\ Eq\ \((1)\)\ \ *) \
\), "\n", 
    \(\(y1 + \((3/\((10\ )\))\)*\ \((\ 
              y1*w1*f[0, \[Pi]\ \[Xi]1] + \ 
                y2*w2*f[0, \[Pi]\ \[Xi]2] + \ \ y3*w3*
                  f[0, \[Pi]\ \[Xi]3]\  + \ \ y4*w4*
                  f[0, \[Pi]\ \[Xi]4] + \ \ y3*w5*
                  f[0, \[Pi]\ \[Xi]5] + \ \ y2*w6*f[0, \[Pi]\ \[Xi]6] + \ 
                y1*w7*f[0, \[Pi]\ \[Xi]7] + \ y2*w8*f[0, \[Pi]\ \[Xi]8] + \ 
                y3*w9*f[0, \[Pi]\ \[Xi]9] + \ y4*w10*f[0, \[Pi]\ \[Xi]10] + \ 
                y3*w11*f[0, \[Pi]\ \[Xi]11] + \ 
                y2*w12*f[0, \[Pi]\ \[Xi]12]\ )\) // N\) // 
      Simplify\)}], "Input"],

Cell[BoxData[
    \(1.208579293855635`\ y1 + 0.368278150596790787`\ y2 + 
      0.291398385269051551`\ y3 + 0.131699528527895792`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ \ The\ lhs\ of\ Eq\ \((2)\)\ \ *) \n
    \(y2 + \((3/\((10\ )\))\)*\ 
            \((\ y1*w1*f[\[Pi]/6, \[Pi]\ \[Xi]1] + \ 
                y2*w2*f[\[Pi]/6, \[Pi]\ \[Xi]2] + \ \ 
                y3*w3*f[\[Pi]/6, \[Pi]\ \[Xi]3]\  + \ \ 
                y4*w4*f[\[Pi]/6, \[Pi]\ \[Xi]4] + \ \ 
                y3*w5*f[\[Pi]/6, \[Pi]\ \[Xi]5] + \ \ 
                y2*w6*f[\[Pi]/6, \[Pi]\ \[Xi]6] + \ 
                y1*w7*f[\[Pi]/6, \[Pi]\ \[Xi]7] + \ 
                y2*w8*f[\[Pi]/6, \[Pi]\ \[Xi]8] + \ 
                y3*w9*f[\[Pi]/6, \[Pi]\ \[Xi]9] + \ 
                y4*w10*f[\[Pi]/6, \[Pi]\ \[Xi]10] + \ 
                y3*w11*f[\[Pi]/6, \[Pi]\ \[Xi]11] + \ 
                y2*w12*f[\[Pi]/6, \[Pi]\ \[Xi]12]\ )\) // N\) // Simplify
      \)\)], "Input"],

Cell[BoxData[
    \(0.168928473320664673`\ y1 + 1.35450514299252255`\ y2 + 
      0.326861989904439331`\ y3 + 0.149735197952264176`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ \ The\ lhs\ of\ Eq\ \((3)\)\ \ *) \n
    \(y3 + \((3/\((10\ )\))\)*\ 
            \((\ y1*w1*f[\[Pi]/3, \[Pi]\ \[Xi]1] + \ 
                y2*w2*f[\[Pi]/3, \[Pi]\ \[Xi]2] + \ \ 
                y3*w3*f[\[Pi]/3, \[Pi]\ \[Xi]3]\  + \ \ 
                y4*w4*f[\[Pi]/3, \[Pi]\ \[Xi]4] + \ \ 
                y3*w5*f[\[Pi]/3, \[Pi]\ \[Xi]5] + \ \ 
                y2*w6*f[\[Pi]/3, \[Pi]\ \[Xi]6] + \ 
                y1*w7*f[\[Pi]/3, \[Pi]\ \[Xi]7] + \ 
                y2*w8*f[\[Pi]/3, \[Pi]\ \[Xi]8] + \ 
                y3*w9*f[\[Pi]/3, \[Pi]\ \[Xi]9] + \ 
                y4*w10*f[\[Pi]/3, \[Pi]\ \[Xi]10] + \ 
                y3*w11*f[\[Pi]/3, \[Pi]\ \[Xi]11] + \ 
                y2*w12*f[\[Pi]/3, \[Pi]\ \[Xi]12]\ )\) // N\) // Simplify
      \)\)], "Input"],

Cell[BoxData[
    \(0.134250609447494917`\ y1 + 0.315346752595396484`\ y2 + 
      1.36806571336892623`\ y3 + 0.182332420463905613`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ \ The\ lhs\ of\ Eq\ \((4)\)\ \ *) \n
    \(y4 + \((3/\((10\ )\))\)*\ 
            \((\ y1*w1*f[\[Pi]/2, \[Pi]\ \[Xi]1] + \ 
                y2*w2*f[\[Pi]/2, \[Pi]\ \[Xi]2] + \ \ 
                y3*w3*f[\[Pi]/2, \[Pi]\ \[Xi]3]\  + \ \ 
                y4*w4*f[\[Pi]/2, \[Pi]\ \[Xi]4] + \ \ 
                y3*w5*f[\[Pi]/2, \[Pi]\ \[Xi]5] + \ \ 
                y2*w6*f[\[Pi]/2, \[Pi]\ \[Xi]6] + \ 
                y1*w7*f[\[Pi]/2, \[Pi]\ \[Xi]7] + \ 
                y2*w8*f[\[Pi]/2, \[Pi]\ \[Xi]8] + \ 
                y3*w9*f[\[Pi]/2, \[Pi]\ \[Xi]9] + \ 
                y4*w10*f[\[Pi]/2, \[Pi]\ \[Xi]10] + \ 
                y3*w11*f[\[Pi]/2, \[Pi]\ \[Xi]11] + \ 
                y2*w12*f[\[Pi]/2, \[Pi]\ \[Xi]12]\ )\) // N\) // Simplify
      \)\)], "Input"],

Cell[BoxData[
    \(0.114514304505551312`\ y1 + 0.281213805111688621`\ y2 + 
      0.386547051259767915`\ y3 + 1.21771677686581858`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Now\ to\ solve\ the\ four\ equations\ *) \n
    NSolve[{1.208579293855635`\ y1 + 0.368278150596790787`\ y2 + 
            0.291398385269051551`\ y3 + 0.131699528527895792`\ y4 == \ 25, \n
        0.168928473320664673`\ y1 + 1.35450514299252255`\ y2 + 
            0.326861989904439331`\ y3 + 0.149735197952264176`\ y4 == \ 21, \n
        0.134250609447494917`\ y1 + 0.315346752595396484`\ y2 + 
            1.36806571336892623`\ y3 + 0.182332420463905613`\ y4 == \ 13, \n
        0.114514304505551312`\ y1 + 0.281213805111688621`\ y2 + 
            0.386547051259767915`\ y3 + 1.21771677686581858`\ y4 == \ 9}, 
      \ {y1, y2, y3, y4}]\n\)\)], "Input"],

Cell[BoxData[
    \({{y1 \[Rule] 15.6082641263474775`, y2 \[Rule] 12.1916266219134716`, 
        y3 \[Rule] 4.95606783304019504`, y4 \[Rule] 1.53436612270960797`}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[\n
      \t{a0 + a1 + a2 + a3 == \ 15.6082641263474775`, \n\t\t
        a0 + a1/2 - a2/2 - a3 == 12.1916266219134716`, \n\t\t
        a0 - a1/2 - a2/2 + a3 == 4.95606783304019504`, \n\t\t
        a0 - a1 + a2 - a3 == \ 1.53436612270960797`}, {a0, a1, a2, a3}]\)], 
  "Input"],

Cell[BoxData[
    \({{a0 \[Rule] 8.57300319316073711`, a1 \[Rule] 7.10315226417038125`, 
        a2 \[Rule] \(-0.0016880686321941356`\), 
        a3 \[Rule] \(-0.066203262351447023`\)}}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{11, Automatic}, {Automatic, 13}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 2332, 51, 683, "Input"],
Cell[4074, 104, 147, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4258, 111, 790, 15, 171, "Input"],
Cell[5051, 128, 149, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5237, 135, 790, 15, 171, "Input"],
Cell[6030, 152, 149, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6216, 159, 790, 15, 171, "Input"],
Cell[7009, 176, 149, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7195, 183, 681, 10, 267, "Input"],
Cell[7879, 195, 184, 3, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8100, 203, 301, 6, 107, "Input"],
Cell[8404, 211, 199, 3, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

